<?php
// create connection to database
$host = "webdev.iyaserver.com"; // database server address
$userid = "dent_student"; // database user account name
$userpw = "code4Studentuse"; // database user password
$db = "dent_health"; // database name

$mysql = new mysqli(
    $host,
    $userid,
    $userpw,
    $db);

if($mysql->connect_errno) {
    echo "db connection error : " . $mysql->connect_error;
    exit();
}
?>

<!-- these php blocks do not need to be separated, but might as well since in many pages with
    full/normal html likely this block would be lower down in the code -->

<?php

/* php variable notes:
    -  php variables have dollar signs in front of their names, like $filter
    - php variables passed through page url strings are named $_REQUEST["variablename"]
    - if a $_REQUEST variable does not exist it does NOT error, it just returns blank
*/

// going to write some php variable and $_REQUEST code here
if (!empty($_REQUEST["condition"])) {
    // if no url condition was passed into page, default to Diabetes
    $filter = $_REQUEST["condition"];
} else {
    $filter = "Diabetes";
}

// base query
$sql =  "     SELECT 
	                AVG(Age) AS AverageAge,
	                MIN(Age) AS LowAge,
	                MAX(Age) AS HighAge,
	                COUNT(Name) AS NumberPatients
	              FROM healthcare_dataset
	              GROUP BY MedicalCondition
	"; // note NO WHERE clause/filter, but GROUP BY

$results = $mysql->query($sql);

if(!$results) {
    echo "SQL error: ". $mysql->error . " running query <hr>" . $sql . "<hr>";
    exit();
}

// since only query in the page, and just a single line query (one row) that
// does not need a loop, pre-load the query columns into $currentrow

$currentrow = $results->fetch_assoc();

// dump columns into source code of page to debug / see column names and data
echo "<!--<pre> ";
var_dump($currentrow);
echo "</pre>-->";
$results->data_seek(0); // reset results to beginning
?>



<!-- this is a javascript block in the page... NOT php ... but that doesn't mean we
    can't choose to output/inject content into it with php -->

<!-- javascript block. setting up variables -->
<script>
    let condition = "Diabetes";
    let patients = 452;
    let highage = 51.49;
    let lowage = 18;
    let avgage = 85;

    let data = new Array;
    data.push ({
        "condition": "Arthritis",
        "patients": 431,
        "highage": 85,
        "lowage": 18,
        "avgage": 53
    });
    data.push({
        "condition": "Asthma",
        "patients": 420,
        "highage": 85,
        "lowage": 18,
        "avgage": 51.44    })
    data.push({
        "condition": "Cancer",
        "patients": 438,
        "highage": 85,
        "lowage": 18,
        "avgage": 51.28    })
    data.push({
        "condition": "Diabetes",
        "patients": 452,
        "highage": 85,
        "lowage": 18,
        "avgage": 51.49    })
    data.push({
        "condition": "Hypertension",
        "patients": 443,
        "highage": 85,
        "lowage": 18,
        "avgage": 52.51    })
    data.push({
        "condition": "Obesity",
        "patients": 424,
        "highage": 85,
        "lowage": 18,
        "avgage": 53.30    })

    console.log("Outputting data variable:")
    console.log(data);

</script>

<style>
    .box { width: 30px; height: 15px; position:absolute; font-weight:bold;}
    .box2 { width: 100px; height:15px; position:absolute; font-weight: bold;}
    #chart { width:400px; height:225px; position:relative;
        background-image: url(http://iyawebdev.com/acad274/lecture_examples/healthscreen.png)}
    #condition {
        left: 141px; top:60px; font-size: 14pt;
    }
    #patients { left: 199px; top:92px; font-size: 10pt;}
    #avgage { left: 145px; top:122px; font-size: 10pt;}
    #lowage { left: 143px; top:152px; font-size: 10pt;}
    #highage { left: 145px; top:182px; font-size: 10pt;}
    #messagebox { height: 200px; width: 400px; border: 1px solid steelblue;}
    #menu { width: 400px; text-align: center;}
    #menu a{ display:block; float:left; width: 14%; background-color:lightsteelblue; color:white; font-size: 11px; font-family:verdana; text-decoration: none; margin: 1%; }
    #menu a:hover { background-color:steelblue;}

</style>
<div id="menu">
    <a href="#" id="arthritis">Arthritis</a>
    <a href="#" id="asthma">Asthma</a>
    <a href="#" id="cancer">Cancer</a>
    <a href="#" id="diabetes">Diabetes</a>
    <a href="#" id="hypertension">Hypertension</a>
    <a href="#" id="obesity">Obesity</a>
</div>

<br>

<div id="chart">
<!-- chart emptied of all by boxes -->

    <div class="box2" id="condition"></div>
    <div class="box" id="patients"></div>
    <div class="box" id="avgage"></div>
    <div class="box" id="lowage"></div>
    <div class="box" id="highage"></div>

</div>

<br><br>
Message box:
<div id="messagebox"></div>


<script src="https://code.jquery.com/jquery-3.7.1.js"
        integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
        crossorigin="anonymous"></script>
<script><!-- jQuery block -->
    $(document).ready(function(){
        // jQuery code

    /* previous version
        // write variables to div boxes (by id)
        $("#condition").text(condition);
        $("#patients").text(patients);
        $("#highage").text(highage);
        $("#lowage").text(lowage);
        $("#avgage").text(avgage);
    */

    // populating stat boxes from the data recordset
        $("#condition").text(data[0].condition);
        $("#patients").text(data[0].patients);
        $("#highage").text(data[0].highage);
        $("#lowage").text(data[0].lowage);
        $("#avgage").text(data[0].avgage);

        // add message text here

        message = "Patients with " + data[0].condition + " have an average age of " + data[0].avgage
        message += "<br>Patients with " + data[1].condition + " have an average age of " + data[1].avgage
        message += "<br>Patients with " + data[2].condition + " have an average age of " + data[2].avgage
        message += "<br>Patients with " + data[3].condition + " have an average age of " + data[3].avgage
        message += "<br>Patients with " + data[4].condition + " have an average age of " + data[4].avgage
        message += "<br>Patients with " + data[5].condition + " have an average age of " + data[5].avgage
        $("#messagebox").html(message);

        $("#arthritis").on("click", function(){
            $("#condition").text(data[0].condition);
            $("#patients").text(data[0].patients);
            $("#highage").text(data[0].highage);
            $("#lowage").text(data[0].lowage);
            $("#avgage").text(data[0].avgage);
        })

        $("#asthma").on("click", function(){
            $("#condition").text(data[1].condition);
            $("#patients").text(data[1].patients);
            $("#highage").text(data[1].highage);
            $("#lowage").text(data[1].lowage);
            $("#avgage").text(data[1].avgage);
        })

        $("#cancer").on("click", function(){
            $("#condition").text(data[2].condition);
            $("#patients").text(data[2].patients);
            $("#highage").text(data[2].highage);
            $("#lowage").text(data[2].lowage);
            $("#avgage").text(data[2].avgage);
        })

        $("#diabetes").on("click", function(){
            $("#condition").text(data[3].condition);
            $("#patients").text(data[3].patients);
            $("#highage").text(data[3].highage);
            $("#lowage").text(data[3].lowage);
            $("#avgage").text(data[3].avgage);
        })

        $("#hypertension").on("click", function(){
            $("#condition").text(data[4].condition);
            $("#patients").text(data[4].patients);
            $("#highage").text(data[4].highage);
            $("#lowage").text(data[4].lowage);
            $("#avgage").text(data[4].avgage);
        })

        $("#obesity").on("click", function(){
            $("#condition").text(data[5].condition);
            $("#patients").text(data[5].patients);
            $("#highage").text(data[5].highage);
            $("#lowage").text(data[5].lowage);
            $("#avgage").text(data[5].avgage);
        })


    });
</script>


